require_relative '../rspec_helper'
require_relative '../../pages/community_care/community_Care_PageObject'
require 'rubygems'
require_relative '../../module/DriverUtility'
require_relative '../../module/database/MongoUtility'

describe '[Story VAR-8697:  CC Appointment Request – Type of Care;
           Story VAR-9042:  Update "routine" exam language;
           Story VAR-10008: When user selects No option for when a Type of Care is selected - update text from app to request
           Story VAR-10664: Add language when Podiatry (routine exam) option is selected from the Type of Care
           Story VAR-10570: Add language when Primary Care (find a provider) option is selected from the Type of Care
           Story VAR-11223: VAR - CC Type of Care - Add text when Veteran selects No to Do you wish to continue with this request question
           Story VAR-12388: VAR - CC - Add in Primary Care appointment as Type of Care
           Story VAR-12387: CC - Add in Nutrition as Type of Care]' do

  include DriverUtility
  include MongoUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @cc_po = CommunityCare_PageObject.new(@driver)
    @landing_appointments = LandingAppointments.new(@driver)
    @db = connectToMongoDB("var-utility")
    restoreCollection("communityCareTypeOfCares", "var-utility", "communityCareTypesOfCare.json", @db)
  end

  after(:all) do
    @cc_po.loginLogout.logout
  end

  context "AC#VAR-8823|TC#VAR-8824:CC Appointment Request – Type of Care;
           AC#VAR-9679|TC#9680:Update routine exam language
           AC#VAR-10173|TC#10174:When user selects 'No' option for when a Type of Care is selected - update text from 'app' to 'request'
           AC#VAR-10823|TC#10824:Add language when 'Podiatry (routine exam)' option is selected from the Type of Care
           AC#VAR-11215|TC#11216:Add language when 'Primary Care (find a provider)' option is selected from the Type of Care
           AC#VAR-11393|TC#11394:VAR - CC Type of Care - Add text when Veteran selects 'No' to 'Do you wish to continue with this request' question" do

    it "Login and navigate to step 3/4 wizard of CC Request" do
      @cc_po.common.loginEndsOnHome(pw_redacted)
      @cc_po.common.selectAddAppointmentButton("CC")
      @cc_po.communityCare.eligibility_yes_element.click
      @cc_po.communityCare.continue_btn
    end

    it "verify the Type of Care section and drop-down list" do
      @cc_po.communityCare.facility_radio_btn_elements[1].click
      @cc_po.communityCare.care_type_section_element.when_visible(TIME_OUT_LIMIT)
      actual_content = @cc_po.communityCare.care_type_section_element.text.split("\n")
      expected_content = [\
        "Step 4: Type of Care",
        "* What type of care do you need?",
        "Select","Audiology (hearing aid support)", "Audiology (routine hearing exam)","Find a Provider (primary care)", "Nutrition (routine exam)", "Optometry (routine eye exam)", "Podiatry (routine exam)", "Primary Care (routine appointment)",
      ]
      comp_text(expected_content, actual_content)
    end

    it "verify care type selection generates additional question" do
      @cc_po.communityCare.selectTypeOfCare("Optometry (routine eye exam)")
      @cc_po.communityCare.care_type_continue_element.when_visible(TIME_OUT_LIMIT)
      actual_content = @cc_po.communityCare.care_type_continue_element.text.split("\n")
      expected_content = [\
        "* Do you wish to continue with your request?",
        "Yes", "No"
      ]
      comp_text(expected_content, actual_content)
      expect(@cc_po.communityCare.con_yes_element.selected?).to eq false
      expect(@cc_po.communityCare.con_no_element.selected?).to eq false
    end

    it "should verify Continue button remain disabled when  No radio button is selected" do
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq false
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq("This app currently only supports routine eye exams. If you have other needs, please contact your Primary Care Provider to discuss the issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
    end

    it "continue button should be enabled selection of Yes" do
      @cc_po.communityCare.con_yes_element.click
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq true
    end

    it "should verify selection of Audiology generates proper routine exam message" do
      @cc_po.communityCare.selectTypeOfCare("Audiology (hearing aid support)")
      expect(@cc_po.communityCare.care_typ_details_element.text).to eq("This is an office visit for Veterans who already have a hearing aid and who need assistance with the device. This visit is for trouble shooting or adjusting your hearing aid for best performance. This may include technical adjustments, cleaning, and/or reprogramming for new listening situations and environments. This is not a visit to initially be evaluated for or to obtain a hearing aid.")
    end

    it "should verify the expected informational languages are displayed" do
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq("This request is for hearing aid support only. If you have other needs, please contact your Primary Care Provider to discuss the issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq false
    end

    it "should verify  selection of Audiology generates proper routine exam message" do
      @cc_po.communityCare.selectTypeOfCare("Audiology (routine hearing exam)")
      expect(@cc_po.communityCare.care_typ_details_element.text).to eq("This includes an office visit for a hearing exam and evaluation using non-invasive tests to check your hearing and inner ear health. The exam may lead to prevention and treatment recommendations, a request for further consultation, and/or a recommendation for hearing aids. A routine exam is not for any new or sudden changes with your hearing or ears.")
    end

    it "should verify the expected informational languages are displayed" do
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq("This request is for routine hearing exam only. If you have other needs, please contact your Primary Care Provider to discuss the issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq false
    end

    it "should verify selection of Podiatry generates proper routine exam message" do
      @cc_po.communityCare.selectTypeOfCare("Podiatry (routine exam)")
      expect(@cc_po.communityCare.care_typ_details_element.text).to eq("This includes an office visit for an exam of the foot, ankle and related structures of the leg. The exam may lead to diagnosis and treatment to include common conditions like callous, bunions, and other conditions requiring in office treatment, orthotics, and possibly the need for surgery. If you are experiencing any acute conditions or sudden onset of pain, break in the skin with possible infection, please contact your local VAMC.")
    end

    it "should verify the expected informational languages are displayed" do
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq("This request currently only supports routine podiatry exams. If you have other needs, please contact your Primary Care Provider to discuss this issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq false
    end

    it "should verify selection of Primary Care generates proper routine exam message" do
      @cc_po.communityCare.selectTypeOfCare("Find a Provider (primary care)")
      expect(@cc_po.communityCare.care_typ_details_element.text).to eq("If approved, you'll be assigned to a primary care provider in the community to whom we will send the approved referral. Once assigned, you will be provided information and will need to contact the provider’s office directly for preventive and other health care needs for the duration of the approved referral.")
    end

    it "should verify the expected informational languages are displayed" do
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq("This request currently only supports the finding of a Primary Care Provider. If you have other needs, please contact your local VA Medical Center to discuss this issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq false
    end

    it "should select Nutrition" do
       @cc_po.communityCare.selectTypeOfCare("Nutrition (routine exam)")
       expect(@cc_po.communityCare.care_typ_details_element.text).to eq("This includes office visit(s) which will provide education on a healthy lifestyle including food and drink choices, reading food labels, and limits on nutritional intake.")
    end

    it "should verify selection of Nutrition generates proper routine exam message" do
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq("This includes office visit(s) which will provide education on a healthy lifestyle including food and drink choices, reading food labels, and limits on nutritional intake. If you have other needs, please contact your local VA Medical Center to discuss this issue. If you are distance eligible and do not have a Primary Care Provider, you can use this app to request help in getting one assigned.")
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq false
    end

    it "should verify selection of Primary Care generates proper routine exam message" do
      @cc_po.communityCare.selectTypeOfCare("Primary Care (routine appointment)")
      expect(@cc_po.communityCare.care_typ_details_element.text).to eq("This includes office visit(s) with a Primary Care Provider, focused on routine/acute patient complaints, wellness and disease prevention resulting in improved veteran health.")
    end

    it "should verify selection of Nutrition generates proper routine exam message" do
      @cc_po.communityCare.con_no_element.click
      expect(@cc_po.communityCare.no_custm_msg_element.text).to eq("This includes office visit(s) with a Primary Care Provider, focused on routine/acute patient complaints, wellness and disease prevention resulting in improved veteran health. If you have other needs, please contact your local VA Medical Center to discuss this issue. If you are not distance eligible and do not have a Primary Care Provider, you can use this app to request a VA Appointment with a Primary Care Provider.")
      expect(@cc_po.communityCare.continue_btn_element.enabled?).to eq false
    end

    it "should verify 'Previous' and 'Exit' buttons are always enabled and 'Confirmation' modal is displayed" do
      expect(@cc_po.communityCare.previous_btn_element.enabled?).to eq true
      expect(@cc_po.communityCare.exit_button_element.enabled?).to eq true
    end

    it "should verify the content of Exit Modal" do
      @cc_po.communityCare.exit_button
      actual_content = @cc_po.modal.exit_modal_element.text.split("\n")
      expected_content = [\
      "Exit Confirmation",
      "You are about to leave New Appointment/Request form. Any changes you have made will be lost. Do you want to continue?",
      "Yes No"

      ]
      comp_text(expected_content, actual_content)
      @cc_po.modal.cancel_yes

    end

  end

  def comp_text(expected_content, actual_content)
    expected_content.each_with_index do |expectedScreenRow, i|
      expect(actual_content[i].to_s.strip).to eq(expectedScreenRow.to_s.strip)
    end
    expect(expected_content.size).to eq(actual_content.size)
  end

end


